package cn.zhxu.toys.util;

import java.util.List;
import java.util.function.Predicate;

public class ListUtils {

    public static <T> int indexOf(List<T> list, Predicate<T> predicate) {
        if (list == null) return -1;
        int size = list.size();
        for (int i = 0; i < size; i++) {
            if (predicate.test(list.get(i))) {
                return i;
            }
        }
        return -1;
    }

    public static <T> int indexOf(T[] list, Predicate<T> predicate) {
        if (list == null) return -1;
        for (int i = 0; i < list.length; i++) {
            if (predicate.test(list[i])) {
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(List<T> list, Predicate<T> predicate) {
        if (list == null) return -1;
        int size = list.size();
        for (int i = size - 1; i >= 0; i--) {
            if (predicate.test(list.get(i))) {
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] list, Predicate<T> predicate) {
        if (list == null) return -1;
        for (int i = list.length - 1; i >= 0; i--) {
            if (predicate.test(list[i])) {
                return i;
            }
        }
        return -1;
    }

}
