package cn.zhys513.common.seetaface;

import java.io.File;
import java.lang.reflect.Field;

/**
 * 获取打包后jar的路径信息
 * 
 * @author Rex
 */
public class JarToolUtil {

	/**
	 * windows
	 * 
	 * @param lib
	 * @param path
	 * @throws Exception
	 * @throws NoSuchFieldException
	 */
	public static void loadJNILibDynamically(String lib, String path) throws Exception {
		System.setProperty("java.library.path", System.getProperty("java.library.path") + ";" + path);
		Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
		fieldSysPath.setAccessible(true);
		fieldSysPath.set(null, null);
		// C++动态链接库
		System.loadLibrary(lib);
	}

	/**
	 * 获取jar绝对路径
	 * 
	 * @return
	 */
	public static String getJarPath() {
		File file = getFile();
		if (file == null)
			return null;
		return file.getAbsolutePath();
	}

	/**
	 * 获取jar目录
	 * 
	 * @return
	 */
	public static String getJarDir() {
		File file = getFile();
		if (file == null)
			return null;
		return getFile().getParent();
	}

	/**
	 * 获取jar包名
	 * 
	 * @return
	 */
	public static String getJarName() {
		File file = getFile();
		if (file == null)
			return null;
		return getFile().getName();
	}

	/**
	 * 获取当前Jar文件
	 * 
	 * @return
	 */
	private static File getFile() {
		// 关键是这行...
		String path = JarToolUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile();
		try {
			path = java.net.URLDecoder.decode(path, "UTF-8"); // 转换处理中文及空格
		} catch (java.io.UnsupportedEncodingException e) {
			return null;
		}
		return new File(path);
	}
}