package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import java.io.Serializable;

/**
 * 带乐观锁的基础实体
 *
 * @author Li Ruitong
 * @date 2020/6/18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@MappedSuperclass
public class ZiyiLockingEntity<ID extends Serializable> extends ZiyiEntity<ID> implements Serializable {
    /**
     * 乐观锁
     */
    @Version
    @Column(name = "revision")
    private Integer revision = 0;
}
