package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 需要软删除的DTO
 *
 * @author Li Ruitong
 * @date 2020/5/27
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ZiyiSoftDeletableDTO<ID extends Serializable> extends ZiyiDTO<ID> {
    /**
     * 删除时间
     */
    @ApiModelProperty(value = "删除时间")
    private LocalDateTime deleteAt = null;

    /**
     * 删除标识  0未删除 1删除
     */
    @ApiModelProperty(value = "删除标识  0未删除 1删除")
    private boolean deleteFlag;
}

