package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.repository;

import cn.ziyicloud.framework.boot.autoconfigure.data.jpa.entity.ZiyiSelfRelevance;
import cn.ziyicloud.framework.boot.enums.ErrorCodeEnum;
import cn.ziyicloud.framework.boot.exception.ZiyiException;
import cn.ziyicloud.framework.boot.util.IdUtils;
import cn.ziyicloud.framework.boot.util.conlection.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 自关联表 扩展jpa repository
 *
 * @author Li Ruitong
 * @date 2020/5/25
 */
public interface ZiyiSelfRelevanceRepository<T extends ZiyiSelfRelevance<ID>, ID extends Serializable> extends ZiyiJpaRepository<T, ID> {
    /**
     * 根据 pid 查询是否存在
     *
     * @param pid pid
     * @return true--存在
     */
    boolean existsByPid(ID pid);

    /**
     * 根据 PID 查询
     *
     * @param pid pid
     * @return 符合条件的对象集合
     */
    List<T> findByPid(ID pid);

    /**
     * 根据 pIds 查询
     *
     * @param pIds ids
     * @return Set<T>
     */
    List<T> findByPidIn(Iterable<ID> pIds);

    /**
     * 校验pid
     *
     * @param pid    pid
     * @param id     id
     * @param rootId rootId
     */
    default void checkPid(ID pid, ID id, ID rootId) {
        boolean exists = null == pid || rootId == pid || existsById(pid);
        if (!exists) {
            throw new ZiyiException(ErrorCodeEnum.PID_NOT_EXIST);
        } else {
            if (id != null && id.equals(pid)) {
                throw new ZiyiException(ErrorCodeEnum.PID_IS_SELF);
            }
        }
    }

    /**
     * 获取所有子部门
     *
     * @param ids          ids
     * @param childrenList subList
     * @return Set<T>
     */
    default List<T> getAllSub(List<ID> ids, List<T> childrenList) {
        List<T> children = findByPidIn(ids);

        if (children.isEmpty()) {
            return childrenList;
        }

        ids = IdUtils.getIds(children);
        // 作差
        ids = CollectionUtils.subtractions(ids, IdUtils.getIds(childrenList));
        childrenList.addAll(children);
        return getAllSub(ids, childrenList);
    }

    /**
     * 获取所有上级部门
     *
     * @param ids        /
     * @param parentList /
     * @return Set<T>
     */
    default List<T> getAllParent(List<ID> ids, List<T> parentList) {
        List<T> parent = findAllById(ids);
        if (parent.isEmpty()) {
            return parentList;
        }
        ids = IdUtils.getIds(parent);
        // 作差
        ids = CollectionUtils.subtractions(ids, IdUtils.getIds(parentList));
        parentList.addAll(parent);
        return getAllParent(ids, parentList);
    }
}
