package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.repository;

import cn.ziyicloud.framework.boot.autoconfigure.data.jpa.entity.ZiyiSoftDeletableEntity;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.io.Serializable;
import java.util.List;

/**
 * 软删除--扩展jpa repository
 *
 * @author Li Ruitong
 * @date 2020/5/25
 */
public interface ZiyiSoftDeletableRepository<T extends ZiyiSoftDeletableEntity<ID>, ID extends Serializable> extends ZiyiJpaRepository<T, ID> {
    /**
     * 查找所有
     *
     * @return 返回所有未软删除的实体
     */
    @Override
    @Query("select e from #{#entityName} e where e.deleteFlag=false")
    List<T> findAll();

    /**
     * 查询软删除的实体
     *
     * @return 返回所有已软删除的实体
     */
    @Query("select e from #{#entityName} e where e.deleteFlag=true")
    List<T> recycleBin();

    /**
     * 软删除
     * 查询或删除需要添加  @Modifyin注解
     *
     * @param id must not be null
     */
    @Query("update #{#entityName} e set e.deleteFlag=true where e.id=?1")
    @Modifying
    void softDelete(ID id);

}
