package cn.ziyicloud.framework.boot.autoconfigure.data.redis;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Configuration properties for Redis.
 *
 * @author Li Ruitong
 * @date 2020/5/25
 */
@Data
@ConfigurationProperties(prefix = "ziyi.redis")
public class RedisProperties {
    /**
     * 启用fastjson做为redis值序列化
     */
    private boolean fastJson = false;
    /**
     * redis缓存过滤默认时间 单位秒 半个小时
     */
    private int defaultExpireTime = 1800;
}
