package cn.ziyicloud.framework.boot.autoconfigure.fastjson;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Configuration properties for FastJson.
 *
 * @author Li Ruitong
 * @date 2020/5/15
 */
@Data
@ConfigurationProperties(prefix = "ziyi.fast-json.http-message-converter")
public class FastJsonProperties {
    /**
     * 启用fastjson做为httpMessageConverter
     */
    private boolean enable;
    /**
     * FastJson序列化 驼峰转下划线，默认为false
     */
    private boolean snakeCase;
    /**
     * FastJson序列化 SerializerFeature.WriteMapNullValue 是否输出值为null的字段,默认为false
     */
    private boolean serializerMap;
    /**
     * FastJson序列化 SerializerFeature.WriteEnumUsingName 用枚举name()输出,默认为false
     */
    private boolean serializerEnum;
    /**
     * FastJson序列化 SerializerFeature.WriteNullListAsEmpty List字段如果为null,输出为[],而非null
     */
    private boolean serializerList = true;
    /**
     * FastJson序列化 SerializerFeature.WriteNullStringAsEmpty 字符类型字段如果为null,输出为”“,而非null
     */
    private boolean serializerString;
    /**
     * FastJson序列化 SerializerFeature.WriteNullNumberAsZero 数值字段如果为null,输出为0,而非null
     */
    private boolean serializerNumber;
    /**
     * FastJson序列化 SerializerFeature.WriteNullBooleanAsFalse Boolean字段如果为null,输出为false,而非null
     */
    private boolean serializerBoolean = true;
    /**
     * FastJson序列化 SerializerFeature.SkipTransientField 如果是true，类中的Get方法对应的Field是transient，序列化时将会被忽略。默认为true
     */
    private boolean serializerSkip = true;
    /**
     * FastJson序列化 SerializerFeature.SortField 按字段名称排序后输出。默认为false
     */
    private boolean serializerSort;
    /**
     * FastJson序列化 SerializerFeature.WriteClassName 序列化时写入类型信息，默认为false。反序列化是需用到
     */
    private boolean serializerClass;
    /**
     * FastJson序列化 SerializerFeature.WriteDateUseDateFormat 全局修改日期格式,默认为false。JSON.DEFFAULT_DATE_FORMAT = “yyyy-MM-dd”;JSON.toJSONString
     * (obj, SerializerFeature.WriteDateUseDateFormat);
     */
    private boolean serializerDate;
    /**
     * FastJson序列化 SerializerFeature.WriteDateUseDateFormat 对斜杠’/’进行转义，默认false
     */
    private boolean serializerSlash;
    /**
     * FastJson序列化 SerializerFeature.NotWriteDefaultValue 不序列化默认值，默认false
     */
    private boolean serializerDefault;
}
