package cn.ziyicloud.framework.boot.autoconfigure.fastjson.filter.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.BigDecimal;

/**
 * ZiyiBoot Decimal Accuracy Filter
 *
 * @author Li Ruitong
 * @date 2020/5/15
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ZiyiDecimalAccuracy {
    /**
     * 保留两个小数点
     *
     * @return number
     */
    int scale() default 2;

    /**
     * BigDecimal 舍位模式
     * 默认截取模式
     *
     * @return mode
     */
    int roundingMode() default BigDecimal.ROUND_DOWN;
}
