package cn.ziyicloud.framework.boot.autoconfigure.fastjson.filter.annotation;

import cn.ziyicloud.framework.boot.autoconfigure.fastjson.filter.enums.ValueHidePositionEnum;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * ZiyiBoot Value Hide Value Filter
 *
 * @author Li Ruitong
 * @date 2020/5/15
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ZiyiValueHide {
    /**
     * 隐藏长度
     *
     * @return number
     */
    int length() default 0;

    /**
     * 开始隐藏位置
     *
     * @return start position
     */
    int start() default 0;

    /**
     * 隐藏位置的枚举
     *
     * @return {@link ValueHidePositionEnum}
     */
    ValueHidePositionEnum position() default ValueHidePositionEnum.MIDDLE;

    /**
     * 隐藏的占位符
     * 默认值是'*'
     *
     * @return placeholder
     */
    char placeholder() default '*';
}
