package cn.ziyicloud.framework.boot.autoconfigure.web;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static cn.ziyicloud.framework.boot.autoconfigure.web.ZiyiWebProperties.ZIYI_WEB_PREFIX;

/**
 * web参数处理
 *
 * @author Li Ruitong
 * @date 2020/6/29
 */
@Data
@ConfigurationProperties(prefix = ZIYI_WEB_PREFIX)
public class ZiyiWebProperties {
    /**
     * 安全配置前缀
     */
    public static final String ZIYI_WEB_PREFIX = "ziyi.web";

    /**
     * 是否开启相关web统一处理
     */
    private boolean enable = true;

    /**
     * rsa加密解密配置
     */
    private RsaInfo rsa = new RsaInfo();


    @Data
    public static class RsaInfo {
        /**
         * 是否开启rsa自动加密解密
         */
        private boolean open = false;
        /**
         * 私钥
         */
        private String privateKey = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALqeqm7j7EBjLK9YoM2aBK6icbDpwV7wnmoRGK/SV0lwQ9ejZYiSyYGQ7xTp6JIcHvnwbvq7Lt3ypJkmNvi6dBGSSbL3yNufh624w0Yv0nVoEN5gPjrKP3F+xqmRomyt3LSkDbN98MAQLqCLiKyZxF8AkvA7ZNCpabRZdksEz8V/AgMBAAECgYEAkF4sROrHmivepqtugn9yvdJnF1BOSm7kbfNZ4LJc2jAiG5CI/HVps3T2r3wgcd+VSw9oG0lxATwzf1Kj1hkPrjE998R2F/Um9SbmE2Lj2Y8qdyyX2Qvan41BZERUrS4wAJHp8yV+N+pV0eYbQokXcbDSh0uJRXec6SyndKwV9xECQQDqGhtHQs/QPJ0uYOhj9OSpFrVNixtwy0TczfuCri/yljj+xNCkFWI8T1nqcjImyc11+3Aa0Kdvc0MYnYeioszHAkEAzBOIbZWUv5w1A186sWpdrRtxxi5LZZ1Mu38XsYZuIW8d515mv9sL3OG0FzkVbxX2cT9pt7hI1M0HORPa1IlZiQJBAKxm3X/1bCXm/bqSE5LJXzxHRO3+bA79I5GZAIiUzyrQBtlZCG5OcTIJHibSQqzeITmqGj0lPKmPMPKH0MOtMTECQEG8EPfrdKx7rn/VjtxS/LWj33QMuXCTyIGkoIcoXBUc6675M3OdJScS9KV+V68ejfFQkccB70PMfwUdpiFL1LECQH4tiaHXETZQ4fY5kEAksERQ+1idN57gF7kTzT6Jvd9oKOMht5JCOZv601dFbXdY67XgX4zMhz7SMpzlUn/cA00=";
        /**
         * 公钥
         */
        private String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC6nqpu4+xAYyyvWKDNmgSuonGw6cFe8J5qERiv0ldJcEPXo2WIksmBkO8U6eiSHB758G76uy7d8qSZJjb4unQRkkmy98jbn4etuMNGL9J1aBDeYD46yj9xfsapkaJsrdy0pA2zffDAEC6gi4ismcRfAJLwO2TQqWm0WXZLBM/FfwIDAQAB";

    }
}
