/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.data.mongo.listener;

import cn.ziyicloud.framework.boot.autoconfigure.data.mongo.annotation.ZiyiAutoIncrement;
import cn.ziyicloud.framework.boot.autoconfigure.data.mongo.entity.Sequence;
import java.lang.reflect.Field;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.util.ReflectionUtils;

public class SaveEventListener
extends AbstractMongoEventListener<Object> {
    private final MongoTemplate mongoTemplate;

    public SaveEventListener(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void onBeforeConvert(BeforeConvertEvent<Object> event) {
        Object source = event.getSource();
        ReflectionUtils.doWithFields(source.getClass(), field -> {
            Object id;
            ReflectionUtils.makeAccessible((Field)field);
            if (field.isAnnotationPresent(ZiyiAutoIncrement.class) && (id = field.get(source)) == null) {
                field.set(source, String.valueOf(this.getNextId(source.getClass().getSimpleName())));
            }
        });
        super.onBeforeConvert(event);
    }

    private Long getNextId(String collName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"collName").is((Object)collName));
        Update update = new Update();
        update.inc("incId", (Number)1);
        FindAndModifyOptions options = new FindAndModifyOptions();
        options.upsert(true);
        options.returnNew(true);
        Sequence seq = (Sequence)this.mongoTemplate.findAndModify(query, (UpdateDefinition)update, options, Sequence.class);
        return seq.getIncId();
    }
}

