/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.data.redis;

import cn.ziyicloud.framework.boot.autoconfigure.data.redis.RedisProperties;
import cn.ziyicloud.framework.boot.autoconfigure.data.redis.RedisUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@ConditionalOnClass(value={RedisOperations.class})
@EnableConfigurationProperties(value={RedisProperties.class})
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
public class ZiyiRedisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ZiyiRedisAutoConfiguration.class);
    @Value(value="${spring.redis.database:0}")
    private int defaultDbIndex;
    private RedisTemplate<String, Object> template;
    private final RedisProperties properties;

    public ZiyiRedisAutoConfiguration(RedisProperties properties) {
        this.properties = properties;
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        RedisSerializer<Object> valueSerializer = this.getValueSerializer();
        redisTemplate.setValueSerializer(valueSerializer);
        redisTemplate.setHashValueSerializer(valueSerializer);
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        this.setTemplate((RedisTemplate<String, Object>)redisTemplate);
        RedisUtils.init(this.template, this.defaultDbIndex);
        return redisTemplate;
    }

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory lettuceConnectionFactory) {
        RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig();
        defaultCacheConfig = defaultCacheConfig.entryTtl(Duration.ofSeconds(this.properties.getDefaultExpireTime())).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(this.getValueSerializer())).disableCachingNullValues();
        return RedisCacheManager.builder((RedisConnectionFactory)lettuceConnectionFactory).cacheDefaults(defaultCacheConfig).build();
    }

    private RedisSerializer<Object> getValueSerializer() {
        if (this.properties.isFastJson()) {
            log.info("\u7528FastJson\u505a\u4e3aredis\u503c\u7684\u5e8f\u5217\u5316");
            ParserConfig.getGlobalInstance().setAutoTypeSupport(true);
            return new FastJsonRedisSerializer<Object>(Object.class);
        }
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper mapper = new ObjectMapper();
        mapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.registerModule((Module)new JavaTimeModule());
        return new GenericJackson2JsonRedisSerializer(mapper);
    }

    public int getDefaultDbIndex() {
        return this.defaultDbIndex;
    }

    public RedisTemplate<String, Object> getTemplate() {
        return this.template;
    }

    public RedisProperties getProperties() {
        return this.properties;
    }

    public void setDefaultDbIndex(int defaultDbIndex) {
        this.defaultDbIndex = defaultDbIndex;
    }

    public void setTemplate(RedisTemplate<String, Object> template) {
        this.template = template;
    }

    static class FastJsonRedisSerializer<T>
    implements RedisSerializer<T> {
        private final byte[] EMPTY_ARRAY = new byte[0];
        private Class<T> clazz;

        public FastJsonRedisSerializer(Class<T> clazz) {
            this.clazz = clazz;
        }

        public byte[] serialize(T t) throws SerializationException {
            if (t == null) {
                return this.EMPTY_ARRAY;
            }
            return JSON.toJSONString(t, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}).getBytes(StandardCharsets.UTF_8);
        }

        public T deserialize(byte[] bytes) throws SerializationException {
            if (bytes == null || bytes.length <= 0) {
                return null;
            }
            String str = new String(bytes, StandardCharsets.UTF_8);
            return (T)JSON.parseObject((String)str, this.clazz);
        }
    }
}

