/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.fastjson;

import cn.ziyicloud.framework.boot.autoconfigure.fastjson.FastJsonProperties;
import cn.ziyicloud.framework.boot.util.reflect.ReflectUtils;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.ObjectUtils;

@Configuration
@ConditionalOnClass(value={FastJsonHttpMessageConverter.class, ConfigurationBuilder.class})
@EnableConfigurationProperties(value={FastJsonProperties.class})
@AutoConfigureBefore(value={HttpMessageConvertersAutoConfiguration.class})
@ConditionalOnProperty(name={"ziyi.fast-json.http-message-converter.enable"}, havingValue="true")
public class ZiyiFastJsonHttpMessageConvertersAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ZiyiFastJsonHttpMessageConvertersAutoConfiguration.class);
    private final FastJsonProperties properties;
    private final BeanFactory beanFactory;
    private static final String[] VALUE_FILTER_PACKAGE = new String[]{"cn.ziyicloud.framework.boot.autoconfigure.fastjson.filter"};

    public ZiyiFastJsonHttpMessageConvertersAutoConfiguration(FastJsonProperties properties, BeanFactory beanFactory) {
        this.properties = properties;
        this.beanFactory = beanFactory;
        log.info("FastJsonHttpMessageConvertersAutoConfiguration");
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters fastJsonHttpMessageConverters() {
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        if (this.properties.isSnakeCase()) {
            SerializeConfig serializeConfig = new SerializeConfig();
            serializeConfig.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
            fastJsonConfig.setSerializeConfig(serializeConfig);
        }
        fastJsonConfig.setSerializerFeatures(this.getSerializerFeatures());
        ArrayList<MediaType> fastMediaTypes = new ArrayList<MediaType>();
        fastMediaTypes.add(new MediaType("application", "json", StandardCharsets.UTF_8));
        fastConverter.setSupportedMediaTypes(fastMediaTypes);
        List packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
        packages.addAll(Arrays.asList(VALUE_FILTER_PACKAGE));
        fastJsonConfig.setSerializeFilters((SerializeFilter[])this.getDefineFilters(packages));
        fastConverter.setFastJsonConfig(fastJsonConfig);
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter(StandardCharsets.UTF_8);
        return new HttpMessageConverters(new HttpMessageConverter[]{fastConverter, stringConverter});
    }

    private SerializerFeature[] getSerializerFeatures() {
        ArrayList<SerializerFeature> serializerFeatures = new ArrayList<SerializerFeature>();
        serializerFeatures.add(SerializerFeature.DisableCircularReferenceDetect);
        serializerFeatures.add(SerializerFeature.PrettyFormat);
        if (this.properties.isSerializerMap()) {
            serializerFeatures.add(SerializerFeature.WriteMapNullValue);
        }
        if (this.properties.isSerializerEnum()) {
            serializerFeatures.add(SerializerFeature.WriteEnumUsingName);
        }
        if (this.properties.isSerializerList()) {
            serializerFeatures.add(SerializerFeature.WriteNullListAsEmpty);
        }
        if (this.properties.isSerializerString()) {
            serializerFeatures.add(SerializerFeature.WriteNullStringAsEmpty);
        }
        if (this.properties.isSerializerNumber()) {
            serializerFeatures.add(SerializerFeature.WriteNullNumberAsZero);
        }
        if (this.properties.isSerializerBoolean()) {
            serializerFeatures.add(SerializerFeature.WriteNullBooleanAsFalse);
        }
        if (this.properties.isSerializerSkip()) {
            serializerFeatures.add(SerializerFeature.SkipTransientField);
        }
        if (this.properties.isSerializerSort()) {
            serializerFeatures.add(SerializerFeature.SortField);
        }
        if (this.properties.isSerializerClass()) {
            serializerFeatures.add(SerializerFeature.WriteClassName);
        }
        if (this.properties.isSerializerDate()) {
            serializerFeatures.add(SerializerFeature.WriteDateUseDateFormat);
        }
        if (this.properties.isSerializerSlash()) {
            serializerFeatures.add(SerializerFeature.WriteSlashAsSpecial);
        }
        if (this.properties.isSerializerDefault()) {
            serializerFeatures.add(SerializerFeature.NotWriteDefaultValue);
        }
        return serializerFeatures.toArray(new SerializerFeature[0]);
    }

    private ValueFilter[] getDefineFilters(List<String> packages) {
        HashSet filterClass = new HashSet();
        if (ObjectUtils.isEmpty(packages)) {
            return new ValueFilter[0];
        }
        packages.forEach(pack -> filterClass.addAll(ReflectUtils.getSubClassList((String)pack, ValueFilter.class)));
        LinkedList filters = new LinkedList();
        filterClass.forEach(filter -> {
            try {
                filters.add((ValueFilter)filter.newInstance());
            }
            catch (Exception e) {
                log.error("ValueFilter new instance have error.", (Throwable)e);
            }
        });
        log.info("Loaded ValueFilter : {}", (Object)((Object)filterClass).toString());
        return filters.toArray(new ValueFilter[0]);
    }
}

