/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.fastjson.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;

public class FastJsonUtils {
    private FastJsonUtils() {
    }

    public static String toCamelCaseJsonString(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)SerializeConfigEnum.CamelCase.getSerializeConfig(), (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toPascalCaseJsonString(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)SerializeConfigEnum.PascalCase.getSerializeConfig(), (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toSnakeCaseJsonString(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)SerializeConfigEnum.SnakeCase.getSerializeConfig(), (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toKebabCaseJsonString(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)SerializeConfigEnum.KebabCase.getSerializeConfig(), (SerializerFeature[])new SerializerFeature[0]);
    }

    public static <T> T mapStruct(Object source, TypeReference<T> type) {
        if (source == null) {
            return null;
        }
        return (T)JSON.parseObject((String)FastJsonUtils.replace(JSON.toJSONString((Object)source)), type, (Feature[])new Feature[0]);
    }

    public static <T> T mapStruct(Object source, Class<T> type) {
        if (source == null) {
            return null;
        }
        return (T)JSON.parseObject((String)FastJsonUtils.replace(JSON.toJSONString((Object)source)), type);
    }

    public static String replace(String source) {
        return source.replace("\\", "").replace("\"{", "{").replace("}\"", "}").replace("[\"", "[").replace("]\"", "]");
    }

    private static enum SerializeConfigEnum {
        CamelCase(PropertyNamingStrategy.CamelCase),
        PascalCase(PropertyNamingStrategy.PascalCase),
        SnakeCase(PropertyNamingStrategy.SnakeCase),
        KebabCase(PropertyNamingStrategy.KebabCase);

        private SerializeConfig serializeConfig = new SerializeConfig();
        private ParserConfig parserConfig;

        private SerializeConfigEnum(PropertyNamingStrategy propertyNamingStrategy) {
            this.serializeConfig.propertyNamingStrategy = propertyNamingStrategy;
            this.parserConfig = new ParserConfig();
            this.parserConfig.propertyNamingStrategy = propertyNamingStrategy;
        }

        public SerializeConfig getSerializeConfig() {
            return this.serializeConfig;
        }

        public ParserConfig getParserConfig() {
            return this.parserConfig;
        }
    }
}

