/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.knife4j;

import cn.ziyicloud.framework.boot.autoconfigure.knife4j.ZiyiKnife4jProperties;
import com.github.xiaoymin.knife4j.spring.filter.ProductionSecurityFilter;
import com.github.xiaoymin.knife4j.spring.filter.SecurityBasicAuthFilter;
import com.github.xiaoymin.knife4j.spring.model.MarkdownFiles;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.configuration.SwaggerCommonConfiguration;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationConfiguration;
import springfox.documentation.swagger2.web.Swagger2ControllerWebMvc;

@Configuration
@EnableConfigurationProperties(value={ZiyiKnife4jProperties.class})
@ConditionalOnClass(value={SwaggerCommonConfiguration.class, Swagger2DocumentationConfiguration.class, Swagger2ControllerWebMvc.class})
@ConditionalOnProperty(prefix="ziyi.knife4j", name={"enable"}, havingValue="true", matchIfMissing=true)
@ComponentScan(basePackages={"com.github.xiaoymin.knife4j.spring.plugin"})
@Import(value={Swagger2DocumentationConfiguration.class, BeanValidatorPluginsConfiguration.class})
public class ZiyiKnife4jAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ZiyiKnife4jAutoConfiguration.class);
    private final ZiyiKnife4jProperties knife4jProperties;
    private final ZiyiKnife4jProperties.ZiyiSwaggerProperties swaggerProperties;
    private final BeanFactory beanFactory;

    public ZiyiKnife4jAutoConfiguration(ZiyiKnife4jProperties knife4jProperties, BeanFactory beanFactory) {
        this.knife4jProperties = knife4jProperties;
        this.swaggerProperties = knife4jProperties.getSwagger();
        this.beanFactory = beanFactory;
    }

    @Bean
    public Docket docket() {
        String basePackage = this.swaggerProperties.getBasePackage();
        if (StringUtils.isEmpty((CharSequence)basePackage)) {
            basePackage = (String)AutoConfigurationPackages.get((BeanFactory)this.beanFactory).get(0);
        }
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)basePackage)).paths(PathSelectors.any()).build();
    }

    @Bean(initMethod="init")
    public MarkdownFiles markdownFiles() {
        return new MarkdownFiles(this.knife4jProperties.getMarkdowns() == null ? "" : this.knife4jProperties.getMarkdowns());
    }

    @Bean
    public SecurityBasicAuthFilter securityBasicAuthFilter() {
        return this.knife4jProperties.getBasic().toKnife4jAuthFilter();
    }

    @Bean
    public ProductionSecurityFilter productionSecurityFilter() {
        return new ProductionSecurityFilter(this.knife4jProperties.isProduction());
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).version(this.swaggerProperties.getVersion()).license(this.swaggerProperties.getLicense()).licenseUrl(this.swaggerProperties.getLicenseUrl()).contact(this.swaggerProperties.getContact().toSwaggerContact()).build();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        try {
            Field registrationsField = FieldUtils.getField(InterceptorRegistry.class, (String)"registrations", (boolean)true);
            List registrations = (List)ReflectionUtils.getField((Field)registrationsField, (Object)registry);
            if (registrations != null) {
                for (InterceptorRegistration interceptorRegistration : registrations) {
                    interceptorRegistration.excludePathPatterns(new String[]{"/swagger**/**"}).excludePathPatterns(new String[]{"/webjars/**"}).excludePathPatterns(new String[]{"/v2/**"}).excludePathPatterns(new String[]{"/v3/**"}).excludePathPatterns(new String[]{"/META-INF/resources/webjars/**"}).excludePathPatterns(new String[]{"/doc.html"});
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

