/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.security;

import cn.ziyicloud.framework.boot.autoconfigure.security.SecurityAway;
import cn.ziyicloud.framework.boot.autoconfigure.security.ZiyiSecurityUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="ziyi.security")
public class ZiyiSecurityProperties {
    public static final String ZIYI_SECURITY_PREFIX = "ziyi.security";
    public static final String[] DEFAULT_IGNORE_URLS = new String[]{"/swagger-ui.html", "/swagger-resources/**", "/webjars/**", "/v2/api-docs", "/v2/api-docs-ext", "/META-INF/resources/webjars/**", "/actuator/**", "/druid/**", "/h2-console/**"};
    private String[] authPrefix = new String[]{"/api/**"};
    private SecurityAway away = SecurityAway.memory;
    private List<ZiyiSecurityUser> users = new ArrayList<ZiyiSecurityUser>();
    private String[] ignoringUrls;
    private boolean enableDefaultStoreDelegate = true;
    private boolean disableHttpBasic = true;
    private boolean disableCsrf = true;

    public String[] getAuthPrefix() {
        return this.authPrefix;
    }

    public SecurityAway getAway() {
        return this.away;
    }

    public List<ZiyiSecurityUser> getUsers() {
        return this.users;
    }

    public String[] getIgnoringUrls() {
        return this.ignoringUrls;
    }

    public boolean isEnableDefaultStoreDelegate() {
        return this.enableDefaultStoreDelegate;
    }

    public boolean isDisableHttpBasic() {
        return this.disableHttpBasic;
    }

    public boolean isDisableCsrf() {
        return this.disableCsrf;
    }

    public void setAuthPrefix(String[] authPrefix) {
        this.authPrefix = authPrefix;
    }

    public void setAway(SecurityAway away) {
        this.away = away;
    }

    public void setUsers(List<ZiyiSecurityUser> users) {
        this.users = users;
    }

    public void setIgnoringUrls(String[] ignoringUrls) {
        this.ignoringUrls = ignoringUrls;
    }

    public void setEnableDefaultStoreDelegate(boolean enableDefaultStoreDelegate) {
        this.enableDefaultStoreDelegate = enableDefaultStoreDelegate;
    }

    public void setDisableHttpBasic(boolean disableHttpBasic) {
        this.disableHttpBasic = disableHttpBasic;
    }

    public void setDisableCsrf(boolean disableCsrf) {
        this.disableCsrf = disableCsrf;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZiyiSecurityProperties)) {
            return false;
        }
        ZiyiSecurityProperties other = (ZiyiSecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableDefaultStoreDelegate() != other.isEnableDefaultStoreDelegate()) {
            return false;
        }
        if (this.isDisableHttpBasic() != other.isDisableHttpBasic()) {
            return false;
        }
        if (this.isDisableCsrf() != other.isDisableCsrf()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAuthPrefix(), other.getAuthPrefix())) {
            return false;
        }
        SecurityAway this$away = this.getAway();
        SecurityAway other$away = other.getAway();
        if (this$away == null ? other$away != null : !((Object)((Object)this$away)).equals((Object)other$away)) {
            return false;
        }
        List<ZiyiSecurityUser> this$users = this.getUsers();
        List<ZiyiSecurityUser> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        return Arrays.deepEquals(this.getIgnoringUrls(), other.getIgnoringUrls());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZiyiSecurityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableDefaultStoreDelegate() ? 79 : 97);
        result = result * 59 + (this.isDisableHttpBasic() ? 79 : 97);
        result = result * 59 + (this.isDisableCsrf() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getAuthPrefix());
        SecurityAway $away = this.getAway();
        result = result * 59 + ($away == null ? 43 : ((Object)((Object)$away)).hashCode());
        List<ZiyiSecurityUser> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getIgnoringUrls());
        return result;
    }

    public String toString() {
        return "ZiyiSecurityProperties(authPrefix=" + Arrays.deepToString(this.getAuthPrefix()) + ", away=" + (Object)((Object)this.getAway()) + ", users=" + this.getUsers() + ", ignoringUrls=" + Arrays.deepToString(this.getIgnoringUrls()) + ", enableDefaultStoreDelegate=" + this.isEnableDefaultStoreDelegate() + ", disableHttpBasic=" + this.isDisableHttpBasic() + ", disableCsrf=" + this.isDisableCsrf() + ")";
    }
}

