package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.annotation;

import javax.persistence.criteria.JoinType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * jpa查询注解
 *
 * @author Li Ruitong
 * @date 2020/5/25
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ZiyiJpaQuery {
    // 基本对象的属性名
    String propName() default "";

    // 查询方式
    Type type() default Type.EQ;

    /**
     * 连接查询的属性名，如User类中的dept
     */
    String joinName() default "";

    /**
     * 默认左连接
     */
    JoinType join() default JoinType.LEFT;

    /**
     * 多字段模糊搜索，仅支持String类型字段，多个用逗号隔开, 如@CustomQuery(blurry = "email,username")
     */
    String blurry() default "";

    enum Type {
        //相等
        EQ
        //大于
        , GT
        //大于等于
        , GTE
        //小于
        , LT
        //小于等于
        , LTE
        //中模糊查询
        , INNER_LIKE
        //左模糊查询
        , LEFT_LIKE
        //右模糊查询
        , RIGHT_LIKE
        //包含
        , IN
        // 不等于
        , NE
        // between
        , BETWEEN
        // 不为空
        , NOT_NULL
    }
}
