package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import java.io.Serializable;

/**
 * 带乐观锁的需要软删除的实体
 *
 * @author Li Ruitong
 * @date 2020/5/25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@MappedSuperclass
public class ZiyiSoftDeletableLockingEntity<ID extends Serializable> extends ZiyiSoftDeletableEntity<ID> implements Serializable {
    /**
     * 乐观锁
     */
    @Version
    @Column(name = "revision")
    private Integer revision = 0;
}
