package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.model;

import cn.ziyicloud.framework.boot.autoconfigure.data.jpa.annotation.ZiyiJpaQuery;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 动态查询条件超类
 *
 * @author Li Ruitong
 * @date 2020/5/25
 */
@Data
@NoArgsConstructor
public class ZiyiQueryCriteria<ID extends Serializable> {
    @ApiModelProperty(value = "查询XX时间后创建")
    @ZiyiJpaQuery(propName = "createdTime", type = ZiyiJpaQuery.Type.GTE)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startCreatedTime;

    @ApiModelProperty(value = "查询XX时间前创建")
    @ZiyiJpaQuery(propName = "createdTime", type = ZiyiJpaQuery.Type.LTE)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endCreatedTime;

    @ApiModelProperty(value = "查询XX时间后修改")
    @ZiyiJpaQuery(propName = "updatedTime", type = ZiyiJpaQuery.Type.GTE)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startUpdatedTime;

    @ApiModelProperty(value = "查询XX时间前修改")
    @ZiyiJpaQuery(propName = "updatedTime", type = ZiyiJpaQuery.Type.LTE)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endUpdatedTime;

    @ApiModelProperty(value = "创建者")
    @ZiyiJpaQuery
    private ID createdBy;

    @ApiModelProperty(value = "更新者")
    @ZiyiJpaQuery
    private ID updatedBy;

    @ApiModelProperty(value = "创建者列表")
    @ZiyiJpaQuery(propName = "createdBy", type = ZiyiJpaQuery.Type.IN)
    private List<ID> createdBys;

    @ApiModelProperty(value = "更新者列表")
    @ZiyiJpaQuery(propName = "updatedBy", type = ZiyiJpaQuery.Type.IN)
    private List<ID> updatedBys;
}
