package cn.ziyicloud.framework.boot.autoconfigure.knife4j;

import com.github.xiaoymin.knife4j.spring.filter.SecurityBasicAuthFilter;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.Contact;

import static cn.ziyicloud.framework.boot.autoconfigure.knife4j.ZiyiKnife4jProperties.ZIYI_BOOT_API_PREFIX;

/**
 * 配置文件
 *
 * @author Li Ruitong
 * @date 2020/5/26
 */
@Data
@ConfigurationProperties(prefix = ZIYI_BOOT_API_PREFIX)
public class ZiyiKnife4jProperties {
    public static final String ZIYI_BOOT_API_PREFIX = "ziyi.knife4j";

    /**
     * 基本验证
     */
    private final ZiyiKnife4jHttpBasic basic = new ZiyiKnife4jHttpBasic();

    /**
     * swagger文档配置
     */
    private final ZiyiSwaggerProperties swagger = new ZiyiSwaggerProperties();
    /**
     * 是否生产环境
     */
    private boolean production;

    /**
     * markdown路径
     */
    private String markdowns;


    @Setter
    @Getter
    public static class ZiyiKnife4jHttpBasic {
        /**
         * basic是否开启,默认为false
         */
        private boolean enable = false;

        /**
         * basic 用户名，默认为ziyi
         */
        private String username = "ziyi";

        /**
         * basic 密码，默认为20201123
         */
        private String password = "20201123";

        public SecurityBasicAuthFilter toKnife4jAuthFilter() {
            return new SecurityBasicAuthFilter(enable, username, password);
        }
    }

    @Setter
    @Getter
    public static class ZiyiSwaggerProperties {
        /**
         * swagger扫描本项目的base-package
         * 扫描该package下的所有controller来生成文档
         */
        private String basePackage;
        /**
         * 文档标题
         */
        private String title = "ZiyiBoot快速集成Swagger+Knife4j文档";
        /**
         * 文档描述
         */
        private String description = "ZiyiBoot通过自动化配置快速集成Swagger2+Knife4j文档，仅需一个注解、一个依赖即可。";
        /**
         * 文档版本号
         */
        private String version = "1.0.0";
        /**
         * 文档版权
         */
        private String license = "Li Ruitong";
        /**
         * 文档版权路径
         */
        private String licenseUrl = "";

        /**
         * 文档编写联系人信息
         */
        private final ZiyiContact contact = new ZiyiContact();

        /**
         * 文档接口访问时认证信息
         */
        private final Authorization authorization = new Authorization();
    }

    /**
     * 文档编写联系人信息
     */
    @Setter
    @Getter
    public static class ZiyiContact {
        /**
         * 联系人名称
         */
        private String name = "李瑞桐";
        /**
         * 联系人主页
         */
        private String website = "https://loveyangxiaoyu.gitee.io/lrt_blog/";
        /**
         * 联系人邮箱地址
         */
        private String email = "86415270@qq.com";

        public Contact toSwaggerContact() {
            return new Contact(name, website, email);
        }
    }

    /**
     * 文档接口访问所需认证配置信息
     */
    @Setter
    @Getter
    public static class Authorization {
        /**
         * 整合Oauth2后授权名称
         */
        private String name = "ZiyiBoot Security Oauth 认证头信息";
        /**
         * 整合Oauth2后授权请求头Header内的key-name
         */
        private String keyName = "Authorization";
        /**
         * 整合Oauth2后授权表达式
         */
        private String authRegex = "^.*$";

        public ApiKey toSwaggerApiKey() {
            return new ApiKey(name, keyName, authRegex);
        }
    }
}
