package cn.ziyicloud.framework.boot.autoconfigure.security;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

import static cn.ziyicloud.framework.boot.autoconfigure.security.ZiyiSecurityProperties.ZIYI_SECURITY_PREFIX;

/**
 * 整合Spring Security 相关属性配置
 *
 * @author Li Ruitong
 * @date 2020/5/29
 */
@Data
@ConfigurationProperties(prefix = ZIYI_SECURITY_PREFIX)
public class ZiyiSecurityProperties {
    /**
     * 安全配置前缀
     */
    public static final String ZIYI_SECURITY_PREFIX = "ziyi.security";

    /**
     * 默认的排除路径列表
     */
    public static final String[] DEFAULT_IGNORE_URLS = new String[]{
        "/swagger-ui.html",
        "/swagger-resources/**",
        "/webjars/**",
        "/v2/api-docs",
        "/v2/api-docs-ext",
        "/META-INF/resources/webjars/**",
        "/actuator/**",
        "/druid/**",
        "/h2-console/**"
    };
    /**
     * 认证接口地址的前缀
     * 默认只拦截/api/**下的接口地址
     */
    private String[] authPrefix = new String[]{"/api/**"};

    /**
     * 认证用户存储方式，默认为内存方式
     *
     * @see SecurityAway
     */
    private SecurityAway away = SecurityAway.memory;

    /**
     * 配置内存方式的用户列表
     * key：用户名
     * value：密码
     */
    private List<ZiyiSecurityUser> users = new ArrayList<>();

    /**
     * 排除路径列表，默认排除swagger2以及actuator路径
     */
    private String[] ignoringUrls;

    /**
     * 是否启用默认的用户信息存储委托
     * 如果away=jdbc时，该配置会自动读取api_boot_user_info表内的用户数据
     * 如果配置该值为false，需要实现ApiBootStoreDelegate接口来完成自定义读取用户数据方法
     */
    private boolean enableDefaultStoreDelegate = true;
    /**
     * 禁用Http Basic
     */
    private boolean disableHttpBasic = true;
    /**
     * 禁用CSRF
     */
    private boolean disableCsrf = true;
}
