package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 需要软删除的实体
 *
 * @author Li Ruitong
 * @date 2020/5/25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@MappedSuperclass
public class ZiyiSoftDeletableEntity<ID extends Serializable> extends ZiyiEntity<ID> implements Serializable {
    /**
     * 删除时间
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @Column
    private LocalDateTime deleteAt = null;

    /**
     * 删除标识  0未删除 1删除
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @Column(name = "delete_flag")
    private boolean deleteFlag;
}
