package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.io.Serializable;
import java.util.List;

/**
 * 扩展jpa repository
 *
 * @author Li Ruitong
 * @date 2020/5/25
 */
public interface ZiyiJpaRepository<T, ID extends Serializable> extends JpaRepository<T, ID>, JpaSpecificationExecutor<T> {
    /**
     * 根据id列表删除实体信息
     *
     * @param ids ids 不能是null也不能包含null值
     * @return 已删除实体信息列表
     */
    List<T> deleteAllByIdIn(Iterable<ID> ids);
}
