package cn.ziyicloud.framework.boot.autoconfigure.web;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.swagger.configuration.SwaggerCommonConfiguration;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationConfiguration;
import springfox.documentation.swagger2.web.Swagger2ControllerWebMvc;

import javax.servlet.Servlet;

import static cn.ziyicloud.framework.boot.autoconfigure.web.ZiyiWebProperties.ZIYI_WEB_PREFIX;

/**
 * web自动化配置，统一处理响应值和异常
 * 只有在设置ziyi.web.enable=true时或者在配置文件内不进行配置时（因为默认为true）才会自动化配置该类
 *
 * @author Li Ruitong
 * @date 2020/5/26
 */
@Configuration()
@EnableConfigurationProperties(ZiyiWebProperties.class)
@ConditionalOnClass({Servlet.class, DispatcherServlet.class, WebMvcConfigurer.class, SwaggerCommonConfiguration.class, Swagger2DocumentationConfiguration.class, Swagger2ControllerWebMvc.class})
@AutoConfigureAfter({WebMvcAutoConfiguration.class})
@ComponentScan(basePackages = {"cn.ziyicloud.framework.boot.autoconfigure.web.handler"})
@ConditionalOnProperty(prefix = ZIYI_WEB_PREFIX, name = "enable", havingValue = "true", matchIfMissing = true)
public class ZiyiWebMvcAutoConfigure {

}
