/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.ziyicloud.framework.boot.autoconfigure.data.jpa.annotation.ZiyiJpaQuery;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;

public class ZiyiJpaQueryUtils {
    private static final Logger log = LoggerFactory.getLogger(ZiyiJpaQueryUtils.class);
    public static final String LIKE_SYMBOL = "%";

    private ZiyiJpaQueryUtils() {
    }

    public static <R, Q> Specification<R> buildSpec(Q criteria) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> ZiyiJpaQueryUtils.getPredicate(root, criteria, criteriaBuilder);
    }

    public static <R, Q> Predicate getPredicate(Root<R> root, Q query, CriteriaBuilder builder) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        if (query == null) {
            return builder.conjunction();
        }
        try {
            List<Field> fields = ZiyiJpaQueryUtils.getAllFields(query.getClass(), new ArrayList<Field>());
            for (Field field : fields) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                ZiyiJpaQuery ziyiJpaQuery = field.getAnnotation(ZiyiJpaQuery.class);
                if (ziyiJpaQuery != null) {
                    String propName = ziyiJpaQuery.propName();
                    String joinName = ziyiJpaQuery.joinName();
                    String blurry = ziyiJpaQuery.blurry();
                    String attributeName = StringUtils.isBlank((CharSequence)propName) ? field.getName() : propName;
                    Class<?> fieldType = field.getType();
                    Object val = field.get(query);
                    if (ObjectUtils.isEmpty((Object)val)) continue;
                    Join<?, ?> join = null;
                    if (ObjectUtils.isNotEmpty((Object)blurry)) {
                        String[] blurryList = blurry.split(",");
                        ArrayList<Predicate> orPredicate = new ArrayList<Predicate>();
                        String[] stringArray = blurryList;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String blurryAttr = stringArray[i];
                            orPredicate.add(builder.like(root.get(blurryAttr).as(String.class), LIKE_SYMBOL + val.toString() + LIKE_SYMBOL));
                        }
                        Predicate[] p = new Predicate[orPredicate.size()];
                        list.add(builder.or(orPredicate.toArray(p)));
                        continue;
                    }
                    if (ObjectUtils.isNotEmpty((Object)joinName)) {
                        String[] joinNames;
                        block23: for (String name : joinNames = joinName.split(">")) {
                            switch (ziyiJpaQuery.join()) {
                                case LEFT: {
                                    join = ZiyiJpaQueryUtils.getJoin(root, join, name, JoinType.LEFT, val);
                                    continue block23;
                                }
                                case RIGHT: {
                                    join = ZiyiJpaQueryUtils.getJoin(root, join, name, JoinType.RIGHT, val);
                                    continue block23;
                                }
                                case INNER: {
                                    join = ZiyiJpaQueryUtils.getJoin(root, join, name, JoinType.INNER, val);
                                    continue block23;
                                }
                            }
                        }
                    }
                    switch (ziyiJpaQuery.type()) {
                        case EQ: {
                            list.add(builder.equal(ZiyiJpaQueryUtils.getExpression(attributeName, join, root).as(fieldType), val));
                            break;
                        }
                        case GT: {
                            list.add(builder.greaterThan(ZiyiJpaQueryUtils.getExpression(attributeName, join, root).as(fieldType), (Comparable)val));
                            break;
                        }
                        case GTE: {
                            list.add(builder.greaterThanOrEqualTo(ZiyiJpaQueryUtils.getExpression(attributeName, join, root).as(fieldType), (Comparable)val));
                            break;
                        }
                        case LT: {
                            list.add(builder.lessThan(ZiyiJpaQueryUtils.getExpression(attributeName, join, root).as(fieldType), (Comparable)val));
                            break;
                        }
                        case LTE: {
                            list.add(builder.lessThanOrEqualTo(ZiyiJpaQueryUtils.getExpression(attributeName, join, root).as(fieldType), (Comparable)val));
                            break;
                        }
                        case INNER_LIKE: {
                            list.add(builder.like(ZiyiJpaQueryUtils.getLikeExpression(attributeName, join, root), LIKE_SYMBOL + val.toString() + LIKE_SYMBOL));
                            break;
                        }
                        case LEFT_LIKE: {
                            list.add(builder.like(ZiyiJpaQueryUtils.getLikeExpression(attributeName, join, root), LIKE_SYMBOL + val.toString()));
                            break;
                        }
                        case RIGHT_LIKE: {
                            list.add(builder.like(ZiyiJpaQueryUtils.getLikeExpression(attributeName, join, root), val.toString() + LIKE_SYMBOL));
                            break;
                        }
                        case IN: {
                            if (!CollUtil.isNotEmpty((Collection)((Collection)val))) break;
                            list.add(ZiyiJpaQueryUtils.getExpression(attributeName, join, root).in((Collection)val));
                            break;
                        }
                        case NE: {
                            list.add(builder.notEqual(ZiyiJpaQueryUtils.getExpression(attributeName, join, root), val));
                            break;
                        }
                        case NOT_NULL: {
                            list.add(builder.isNotNull(ZiyiJpaQueryUtils.getExpression(attributeName, join, root)));
                            break;
                        }
                        case BETWEEN: {
                            ArrayList between = new ArrayList((List)val);
                            list.add(builder.between(ZiyiJpaQueryUtils.getExpression(attributeName, join, root).as(between.get(0).getClass()), (Comparable)between.get(0), (Comparable)between.get(1)));
                            break;
                        }
                    }
                }
                field.setAccessible(accessible);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        int size = list.size();
        return builder.and(list.toArray(new Predicate[size]));
    }

    private static <R> Join<?, ?> getJoin(Root<R> root, Join<?, ?> join, String name, JoinType joinType, Object value) {
        join = ObjectUtils.allNotNull((Object[])new Object[]{join, value}) ? join.join(name, joinType) : root.join(name, joinType);
        return join;
    }

    private static <T, R> Expression<T> getExpression(String attributeName, Join<?, ?> join, Root<R> root) {
        if (ObjectUtil.isNotEmpty(join)) {
            return join.get(attributeName);
        }
        return root.get(attributeName);
    }

    private static <R> Expression<String> getLikeExpression(String attributeName, Join<?, ?> join, Root<R> root) {
        if (ObjectUtil.isNotEmpty(join)) {
            return join.get(attributeName).as(String.class);
        }
        return root.get(attributeName).as(String.class);
    }

    private static List<Field> getAllFields(Class<?> clazz, List<Field> fields) {
        if (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            ZiyiJpaQueryUtils.getAllFields(clazz.getSuperclass(), fields);
        }
        return fields;
    }
}

