/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.fastjson.filter;

import cn.ziyicloud.framework.boot.autoconfigure.fastjson.filter.annotation.ZiyiDecimalAccuracy;
import cn.ziyicloud.framework.boot.util.reflect.ReflectUtils;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecimalAccuracyFilter
implements ValueFilter {
    private static final Logger log = LoggerFactory.getLogger(DecimalAccuracyFilter.class);

    public Object process(Object object, String name, Object value) {
        try {
            Field field = ReflectUtils.getField((Object)object, (String)name);
            if (field.isAnnotationPresent(ZiyiDecimalAccuracy.class) && value instanceof BigDecimal) {
                ZiyiDecimalAccuracy decimalAccuracy = field.getDeclaredAnnotation(ZiyiDecimalAccuracy.class);
                BigDecimal decimalValue = (BigDecimal)value;
                return decimalValue.setScale(decimalAccuracy.scale(), decimalAccuracy.roundingMode());
            }
        }
        catch (NoSuchFieldException e) {
            log.debug("\u683c\u5f0f\u5316BigDecimal\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return value;
    }
}

