package cn.ziyicloud.framework.boot.autoconfigure.data.core.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * DTO超类
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseDTO<ID> {
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createdTime;

    /**
     * 最后更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime lastUpdatedTime;

    /**
     * 创建者
     */
    private ID createdBy;

    /**
     * 最后更新者
     */
    private ID lastUpdatedBy;

    /**
     * 备注
     */
    private String remark;
}
