package cn.ziyicloud.framework.boot.autoconfigure.data.core.domain;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * 需要软删除的DTO
 *
 * @author Li Ruitong 86415270@qq.com 2020/5/27
 * @since 1.0.7
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class BaseSoftDeletableDTO<ID> extends BaseDTO<ID> {
    /**
     * 删除时间
     */
    private LocalDateTime deleteAt;

    /**
     * 删除标识  0未删除 1删除
     */
    private Boolean deleteFlag;
}

