package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.annotation;

import javax.persistence.criteria.JoinType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * jpa查询注解
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface JpaQuery {
    /**
     * 对象的属性名
     *
     * @return {@link String}
     */
    String propName() default "";

    /**
     * 查询方式
     *
     * @return {@link QueryType}
     */
    QueryType type() default QueryType.EQ;

    /**
     * 连接查询的属性名，如User类中的dept
     *
     * @return {@link String}
     */
    String joinName() default "";

    /**
     * 默认左连接
     *
     * @return {@link JoinType}
     */
    JoinType join() default JoinType.LEFT;

    /**
     * 多字段模糊搜索，仅支持String类型字段，多个用逗号隔开, 如@JpaQuery(blurry = "email,username")
     *
     * @return {@link String}
     */
    String blurry() default "";

    /**
     * 查询方式枚举
     *
     * @author Li Ruitong
     * @date
     */
    enum QueryType {
        /**
         * 情商
         */
        EQ,
        /**
         * 大于
         */
        GT,
        /**
         * 大于等于
         */
        GTE,
        /**
         * 小于
         */
        LT,
        /**
         * 小于等于
         */
        LTE,
        /**
         * 模糊查询
         */
        INNER_LIKE,
        /**
         * 左模糊查询
         */
        LEFT_LIKE,
        /**
         * 右模糊查询
         */
        RIGHT_LIKE,
        /**
         * 包含
         */
        IN,
        /**
         * 不等于
         */
        NE,
        /**
         * between
         */
        BETWEEN,
        /**
         * 非空
         */
        NOT_NULL,
    }
}
