package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.entity;

import lombok.*;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.EntityListeners;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 通用的基础实体类
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@MappedSuperclass
@EntityListeners({AuditingEntityListener.class})
public class BaseJpaEntity<ID> implements Serializable {
    /**
     * 创建时间
     */
    @CreatedDate
    private LocalDateTime createdTime;

    /**
     * 更新时间
     */
    @LastModifiedDate
    private LocalDateTime lastUpdatedTime;

    /**
     * 创建人
     */
    @CreatedBy
    private ID createdBy;

    /**
     * 更新人
     */
    @LastModifiedBy
    private ID lastUpdatedBy;

    /**
     * 备注
     */
    private String remark;
}
