package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.entity;

import lombok.*;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 需要软删除的实体
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@MappedSuperclass
public class BaseSoftDeletableJpaEntity<ID> extends BaseJpaEntity<ID> implements Serializable {
    /**
     * 删除时间
     */
    private LocalDateTime deleteAt = null;
    /**
     * 删除标识  0未删除 1删除
     */
    private boolean deleteFlag;
}
