package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.model;

import cn.ziyicloud.framework.boot.autoconfigure.data.jpa.annotation.JpaQuery;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 动态查询条件超类
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseQueryCriteria<ID> {
    /**
     * 开始创建时间
     */
    @JpaQuery(propName = "createdTime", type = JpaQuery.QueryType.GTE)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startCreatedTime;

    /**
     * 最终创建时间
     */
    @JpaQuery(propName = "createdTime", type = JpaQuery.QueryType.LTE)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endCreatedTime;

    /**
     * 开始更新时间
     */
    @JpaQuery(propName = "lastUpdatedTime", type = JpaQuery.QueryType.GTE)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startUpdatedTime;

    /**
     * 最后更新时间
     */
    @JpaQuery(propName = "lastUpdatedTime", type = JpaQuery.QueryType.LTE)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endUpdatedTime;

    /**
     * 创建者
     */
    @JpaQuery
    private ID createdBy;

    /**
     * 更新者
     */
    @JpaQuery
    private ID updatedBy;

    /**
     * 创建者列表
     */
    @JpaQuery(propName = "createdBy", type = JpaQuery.QueryType.IN)
    private List<ID> createdBys;

    /**
     * 更新者列表
     */
    @JpaQuery(propName = "lastUpdatedBy", type = JpaQuery.QueryType.IN)
    private List<ID> updatedBys;
}
