package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * 扩展jpa repository
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
public interface BaseJpaRepository<T, ID> extends JpaRepository<T, ID>, JpaSpecificationExecutor<T> {
    /**
     * 根据id列表删除实体信息
     *
     * @param ids ids 不能是null也不能包含null值
     * @return {@link List}<{@link T}> 已删除实体信息列表
     */
    List<T> deleteAllByIdIn(Iterable<ID> ids);
}
