package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.repository;

import cn.ziyicloud.framework.boot.autoconfigure.data.jpa.entity.BaseSoftDeletableJpaEntity;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * 软删除--扩展jpa repository
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
public interface SoftDeletableJpaRepository<T extends BaseSoftDeletableJpaEntity<ID>, ID> extends BaseJpaRepository<T, ID> {
    /**
     * 查找所有未删除
     *
     * @return {@link List}<{@link T}> 结果列表
     */
    @Query("select e from #{#entityName} e where e.deleteFlag=false")
    List<T> listAll();

    /**
     * 查找所有已删除
     *
     * @return {@link List}<{@link T}>
     */
    @Query("select e from #{#entityName} e where e.deleteFlag=true")
    List<T> recycleBin();

    /**
     * 软删除
     * 查询或删除需要添加  @Modifying注解
     *
     * @param id must not be null
     */
    @Query("update #{#entityName} e set e.deleteFlag=true where e.id=?1")
    @Modifying
    void softDelete(ID id);

}
