package cn.ziyicloud.framework.boot.autoconfigure.data.mongo;

import cn.ziyicloud.framework.boot.autoconfigure.data.mongo.listener.SaveEventListener;
import com.mongodb.client.MongoClient;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.*;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

/**
 * Configuration  for mongo.
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Configuration()
@ConditionalOnClass({MongoClient.class, MongoTemplate.class})
@AutoConfigureBefore(MongoAutoConfiguration.class)
public class ZiyiMongoAutoConfiguration {
    @Bean
    SaveEventListener saveEventListener(MongoTemplate mongoTemplate) {
        return new SaveEventListener(mongoTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public MappingMongoConverter mappingMongoConverter(MongoDatabaseFactory factory, MongoMappingContext context, MongoCustomConversions conversions) {
        DbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MappingMongoConverter mappingConverter = new MappingMongoConverter(dbRefResolver, context);
        mappingConverter.setCustomConversions(conversions);
        // Don't save _class to mongo
        mappingConverter.setTypeMapper(new DefaultMongoTypeMapper(null));
        mappingConverter.afterPropertiesSet();
        return mappingConverter;
    }
}
