package cn.ziyicloud.framework.boot.autoconfigure.data.mongo.repository;

import org.springframework.data.mongodb.repository.MongoRepository;

import java.util.List;

/**
 * 扩展jpa repository
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
public interface BaseMongoRepository<T, ID> extends MongoRepository<T, ID> {
    /**
     * 根据id列表删除实体信息
     *
     * @param ids ids 不能是null也不能包含null值
     * @return {@link List}<{@link T}> 已删除实体信息列表
     */
    List<T> deleteAllByIdIn(Iterable<? extends ID> ids);
}
