package cn.ziyicloud.framework.boot.autoconfigure.data.mongo.repository;

import cn.ziyicloud.framework.boot.autoconfigure.data.jpa.entity.BaseSoftDeletableJpaEntity;

import java.util.List;
import java.util.Optional;

/**
 * 软删除--扩展mongo repository
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.7
 */
public interface SoftDeletableMongoRepository<T extends BaseSoftDeletableJpaEntity<ID>, ID> extends BaseMongoRepository<T, ID> {
    /**
     * 通过删除标志查找
     *
     * @param deleteFlag 删除标记
     * @return {@link List}<{@link T}>
     */
    List<T> findAllByDeleteFlag(boolean deleteFlag);

    /**
     * 查找所有未删除
     *
     * @return {@link List}<{@link T}> 结果列表
     */
    default List<T> listAll() {
        return findAllByDeleteFlag(false);
    }

    /**
     * 查找所有已删除
     *
     * @return {@link List}<{@link T}>
     */
    default List<T> recycleBin() {
        return findAllByDeleteFlag(true);
    }

    /**
     * 软删除
     * 查询或删除需要添加  @Modifying注解
     *
     * @param id must not be null
     */
    default void softDelete(ID id) {
        Optional<T> optional = findById(id);
        optional.ifPresent(entity -> {
            entity.setDeleteFlag(true);
            save(entity);
        });
    }

}
