package cn.ziyicloud.framework.boot.autoconfigure.data.redis;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static cn.ziyicloud.framework.boot.autoconfigure.data.core.Constants.REDIS_PROPERTY_PREFIX;

/**
 * Configuration properties for Redis.
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Data
@ConfigurationProperties(prefix = REDIS_PROPERTY_PREFIX)
public class ZiyiRedisProperties {
    /**
     * 启用fastjson做为redis值序列化
     */
    private boolean fastJson = false;
    /**
     * redis缓存过滤默认时间 单位秒 半个小时
     */
    private int defaultExpireTime = 1800;
}
