package cn.ziyicloud.framework.boot.autoconfigure.doc.core;

import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;

import javax.annotation.Nonnull;
import java.lang.reflect.Field;
import java.util.List;

/**
 * 拦截器工具
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
public final class InterceptorUtils {
    private InterceptorUtils() {
    }

    /**
     * 通用拦截器排除swagger设置，所有拦截器都会自动加swagger相关的资源排除信息
     */
    @SuppressWarnings("unchecked")
    public static void excludeSwagger(@Nonnull InterceptorRegistry registry){
        try {
            Field registrationsField = FieldUtils.getField(InterceptorRegistry.class, "registrations", true);
            List<InterceptorRegistration> registrations = (List<InterceptorRegistration>) ReflectionUtils.getField(registrationsField, registry);
            if (registrations != null) {
                for (InterceptorRegistration interceptorRegistration : registrations) {
                    interceptorRegistration
                        .excludePathPatterns("/swagger**/**")
                        .excludePathPatterns("/webjars/**")
                        .excludePathPatterns("/v2/**")
                        .excludePathPatterns("/v3/**")
                        .excludePathPatterns("/META-INF/resources/webjars/**")
                        .excludePathPatterns("/doc.html");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
