package cn.ziyicloud.framework.boot.autoconfigure.doc.core;

import lombok.Data;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.Map;

/**
 * swagger api info配置文件
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Data
public class ZiyiApiInfo {
    /**
     * 标题
     */
    private String title = "ZiyiBoot快速集成Swagger+Knife4j文档";
    /**
     * 描述
     */
    private String description = "ZiyiBoot通过自动化配置快速集成Swagger2+Knife4j文档，仅需一个注解、一个依赖即可。";
    /**
     * 版本
     */
    private String version = "1.0";
    /**
     * url服务条款
     */
    private String termsOfServiceUrl;
    /**
     * 联系
     */
    @NestedConfigurationProperty
    private ZiyiContact contact = new ZiyiContact();
    /**
     * 许可证
     */
    @NestedConfigurationProperty
    private ZiyiLicense license = new ZiyiLicense();
    /**
     * 扩展
     */
    private Map<String, Object> extensions;
}
