package cn.ziyicloud.framework.boot.autoconfigure.doc.core;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import static cn.ziyicloud.framework.boot.autoconfigure.doc.core.Constants.SWAGGER_PREFIX;

/**
 * swagger 配置文件
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Data
@ConfigurationProperties(prefix = SWAGGER_PREFIX)
public class ZiyiSwaggerProperties {
    /**
     * 默认组名
     */
    public static final String DEFAULT_GROUP_NAME = "ziyi-boot";

    /**
     * 是否开启swagger 自动配置
     */
    private boolean auto = true;

    /**
     * host
     */
    private String host;

    /**
     * 要扫描的包
     */
    private String basePackage;

    /**
     * api分组名称
     */
    private String groupName = DEFAULT_GROUP_NAME;

    /**
     * api信息
     */
    @NestedConfigurationProperty
    private ZiyiApiInfo apiInfo = new ZiyiApiInfo();
}
