package cn.ziyicloud.framework.boot.autoconfigure.doc.springfox;

import com.github.xiaoymin.knife4j.spring.filter.SecurityBasicAuthFilter;
import lombok.Data;

/**
 * basicHttp 验证配置文件
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Data
public class ZiyiHttpBasic {
    /**
     * 默认用户名
     */
    public static final String DEFAULT_USERNAME = "ziyi";
    /**
     * 默认密码
     */
    public static final String DEFAULT_PASSWORD = "20201123";
    /**
     * 默认身份验证过滤器
     */
    public static final SecurityBasicAuthFilter DEFAULT_AUTH_FILTER = new SecurityBasicAuthFilter(false, DEFAULT_USERNAME, DEFAULT_PASSWORD);

    /**
     * basic是否开启,默认为false
     */
    private boolean enabled = false;

    /**
     * basic 用户名，默认为ziyi
     */
    private String username = DEFAULT_USERNAME;

    /**
     * basic 密码，默认为20201123
     */
    private String password = DEFAULT_PASSWORD;

    /**
     * 身份验证过滤器
     *
     * @return {@link SecurityBasicAuthFilter}
     */
    public SecurityBasicAuthFilter getAuthFilter() {
        return new SecurityBasicAuthFilter(enabled, username, password);
    }
}
