package cn.ziyicloud.framework.boot.autoconfigure.doc.springfox;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.xiaoymin.knife4j.core.model.MarkdownProperty;
import com.github.xiaoymin.knife4j.spring.extension.OpenApiExtensionResolver;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.stereotype.Component;

import java.util.List;

import static cn.ziyicloud.framework.boot.autoconfigure.doc.core.Constants.KNIFE4J_SPRINGFOX_PREFIX;


/**
 * 配置文件
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Data
@Component
@ConfigurationProperties(prefix = KNIFE4J_SPRINGFOX_PREFIX)
public class ZiyiSpringfoxProperties {
    /**
     * 是否开启Knife4j增强模式
     */
    private boolean enabled = false;
    /**
     * 是否开启默认跨域
     */
    private boolean cors = false;
    /**
     * 是否开启BasicHttp验证
     */
    @NestedConfigurationProperty
    private ZiyiHttpBasic basic = new ZiyiHttpBasic();
    /**
     * 是否生产环境
     */
    private boolean production = false;
    /**
     * 个性化配置
     */
    @NestedConfigurationProperty
    private ZiyiOpenApiExtendSetting setting = new ZiyiOpenApiExtendSetting();
    /**
     * 分组文档集合
     */
    @NestedConfigurationProperty
    private List<ZiyiMarkdownProperty> documents;

    /**
     * 获取扩展解析器
     *
     * @return {@link OpenApiExtensionResolver}
     */
    public OpenApiExtensionResolver getExtensionResolver() {
        return new OpenApiExtensionResolver(setting.getSetting(), BeanUtil.copyToList(documents, MarkdownProperty.class, CopyOptions.create().setIgnoreNullValue(true)));
    }
}
