package cn.ziyicloud.framework.boot.autoconfigure.fastjson.filter;

import cn.ziyicloud.framework.boot.autoconfigure.fastjson.filter.annotation.DecimalAccuracy;
import cn.ziyicloud.framework.boot.util.reflect.ReflectUtils;
import com.alibaba.fastjson.serializer.ValueFilter;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.math.BigDecimal;

/**
 * 小数保留位数过滤器
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Slf4j
public class DecimalAccuracyFilter implements ValueFilter {
    @Override
    public Object process(Object object, String name, Object value) {
        Field field;
        try {

            field = ReflectUtils.getField(object, name);
            //判断字段有ZiyiDecimalAccuracy注解切属于BigDecimal
            if (field.isAnnotationPresent(DecimalAccuracy.class) && value instanceof BigDecimal) {
                DecimalAccuracy decimalAccuracy = field.getDeclaredAnnotation(DecimalAccuracy.class);
                BigDecimal decimalValue = (BigDecimal) value;
                return decimalValue.setScale(decimalAccuracy.scale(), decimalAccuracy.roundingMode());
            }
        } catch (NoSuchFieldException e) {
            log.debug("格式化BigDecimal字段出现异常", e);
        }
        return value;
    }
}
