package cn.ziyicloud.framework.boot.autoconfigure.web;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.servlet.Servlet;

import static cn.ziyicloud.framework.boot.autoconfigure.web.Constants.WEB_ENABLED;
import static cn.ziyicloud.framework.boot.autoconfigure.web.Constants.WEB_HANDLER_PACKAGE;

/**
 * web自动化配置，统一处理响应值和异常
 * 只有在设置ziyi.web.enable=true时或者在配置文件内不进行配置时（因为默认为true）才会自动化配置该类
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Configuration()
@EnableConfigurationProperties(ZiyiWebProperties.class)
@ConditionalOnClass({Servlet.class, DispatcherServlet.class, WebMvcConfigurer.class})
@AutoConfigureAfter({org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration.class})
@ComponentScan(basePackages = {WEB_HANDLER_PACKAGE})
@ConditionalOnProperty(name = WEB_ENABLED, havingValue = "true", matchIfMissing = true)
public class ZiyiWebMvcAutoConfiguration {

}
