package cn.ziyicloud.framework.boot.autoconfigure.web.handler;

import cn.ziyicloud.framework.boot.autoconfigure.web.annotation.ZiyiExcludeBody;
import cn.ziyicloud.framework.boot.autoconfigure.web.annotation.ZiyiResponseBody;
import cn.ziyicloud.framework.boot.model.BaseDataResponse;
import cn.ziyicloud.framework.boot.model.BasePageResponse;
import cn.ziyicloud.framework.boot.model.BaseResponse;
import cn.ziyicloud.framework.boot.util.json.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * 统一响应 拦截
 *
 * @author Li Ruitong 86415270@qq.com
 * @since 1.0.0
 */
@Slf4j
@RestControllerAdvice
@Order(1)
public class ZiyiResponseHandler implements ResponseBodyAdvice<Object> {
    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        boolean exclude = AnnotatedElementUtils.hasAnnotation(returnType.getContainingClass(),
            ZiyiExcludeBody.class) || returnType.hasMethodAnnotation(ZiyiExcludeBody.class);
        if (exclude) {
            return false;
        }
        //含有ZiyiResponseBody注解的类或方法
        return (AnnotatedElementUtils.hasAnnotation(returnType.getContainingClass(), ZiyiResponseBody.class) || returnType.hasMethodAnnotation(ZiyiResponseBody.class));
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        BaseResponse result;
        //兼容原来的接口返回
        if (body instanceof BaseDataResponse) {
            result = (BaseDataResponse<?>) body;
        } else if (body instanceof BasePageResponse) {
            result = (BasePageResponse<?>) body;
        } else if (body instanceof BaseResponse) {
            result = (BaseResponse) body;
        } else {
            result = new BaseDataResponse<>(body);
        }
        //debug时打印响应结果
        if (log.isDebugEnabled()) {
            log.debug("响应参数：{} ", result);
        }
        //处理返回值是String的情况
        if (body instanceof String) {
            return JsonUtils.toJson(result);
        }
        return result;
    }
}
