/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.data.jpa.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.ziyicloud.framework.boot.autoconfigure.data.jpa.annotation.JpaQuery;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;

public final class JpaQueryUtils {
    private static final Logger log = LoggerFactory.getLogger(JpaQueryUtils.class);
    public static final String LIKE_SYMBOL = "%";

    private JpaQueryUtils() {
    }

    public static <R, Q> Specification<R> buildSpec(Q criteria) {
        return (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> JpaQueryUtils.getPredicate(root, criteria, criteriaBuilder);
    }

    public static <R, Q> Predicate getPredicate(Root<R> root, Q query, CriteriaBuilder builder) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        if (query == null) {
            return builder.conjunction();
        }
        try {
            List<Field> fields = JpaQueryUtils.getAllFields(query.getClass(), new ArrayList<Field>());
            for (Field field : fields) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                JpaQuery jpaQuery = field.getAnnotation(JpaQuery.class);
                if (jpaQuery != null) {
                    String propName = jpaQuery.propName();
                    String joinName = jpaQuery.joinName();
                    String blurry = jpaQuery.blurry();
                    String attrName = StringUtils.isBlank((CharSequence)propName) ? field.getName() : propName;
                    Class<?> fieldType = field.getType();
                    Object value = field.get(query);
                    if (ObjectUtils.isEmpty((Object)value)) continue;
                    Join<?, ?> join = null;
                    if (ObjectUtils.isNotEmpty((Object)blurry)) {
                        String[] blurryList = blurry.split(",");
                        ArrayList<Predicate> orPredicate = new ArrayList<Predicate>();
                        String[] stringArray = blurryList;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String blurryAttr = stringArray[i];
                            orPredicate.add(builder.like(root.get(blurryAttr).as(String.class), LIKE_SYMBOL + value + LIKE_SYMBOL));
                        }
                        Predicate[] p = new Predicate[orPredicate.size()];
                        list.add(builder.or(orPredicate.toArray(p)));
                        continue;
                    }
                    if (ObjectUtils.isNotEmpty((Object)joinName)) {
                        String[] joinNames;
                        block9: for (String name : joinNames = joinName.split(">")) {
                            switch (jpaQuery.join()) {
                                case LEFT: {
                                    join = JpaQueryUtils.getJoin(root, join, name, JoinType.LEFT, value);
                                    continue block9;
                                }
                                case RIGHT: {
                                    join = JpaQueryUtils.getJoin(root, join, name, JoinType.RIGHT, value);
                                    continue block9;
                                }
                                case INNER: {
                                    join = JpaQueryUtils.getJoin(root, join, name, JoinType.INNER, value);
                                    continue block9;
                                }
                            }
                        }
                    }
                    Expression expression = JpaQueryUtils.getExpression(attrName, join, root);
                    JpaQueryUtils.buildPredicate(builder, list, jpaQuery, fieldType, value, expression);
                }
                field.setAccessible(accessible);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        int size = list.size();
        return builder.and(list.toArray(new Predicate[size]));
    }

    private static void buildPredicate(CriteriaBuilder builder, List<Predicate> list, JpaQuery jpaQuery, Class<?> fieldType, Object value, Expression<?> expression) {
        switch (jpaQuery.type()) {
            case EQ: {
                list.add(builder.equal(expression, value));
                break;
            }
            case GT: {
                list.add(builder.greaterThan(expression.as(fieldType), (Comparable)value));
                break;
            }
            case GTE: {
                list.add(builder.greaterThanOrEqualTo(expression.as(fieldType), (Comparable)value));
                break;
            }
            case LT: {
                list.add(builder.lessThan(expression.as(fieldType), (Comparable)value));
                break;
            }
            case LTE: {
                list.add(builder.lessThanOrEqualTo(expression.as(fieldType), (Comparable)value));
                break;
            }
            case INNER_LIKE: {
                list.add(builder.like(expression.as(String.class), LIKE_SYMBOL + value + LIKE_SYMBOL));
                break;
            }
            case LEFT_LIKE: {
                list.add(builder.like(expression.as(String.class), LIKE_SYMBOL + value));
                break;
            }
            case RIGHT_LIKE: {
                list.add(builder.like(expression.as(String.class), value + LIKE_SYMBOL));
                break;
            }
            case IN: {
                if (!CollUtil.isNotEmpty((Collection)((Collection)value))) break;
                list.add(expression.in((Collection)value));
                break;
            }
            case NE: {
                list.add(builder.notEqual(expression, value));
                break;
            }
            case NOT_NULL: {
                list.add(builder.isNotNull(expression));
                break;
            }
            case BETWEEN: {
                ArrayList between = new ArrayList((List)value);
                list.add(builder.between(expression.as(between.get(0).getClass()), (Comparable)between.get(0), (Comparable)between.get(1)));
                break;
            }
        }
    }

    private static <R> Join<?, ?> getJoin(Root<R> root, Join<?, ?> join, String name, JoinType joinType, Object value) {
        join = ObjectUtils.allNotNull((Object[])new Object[]{join, value}) ? join.join(name, joinType) : root.join(name, joinType);
        return join;
    }

    private static <T, R> Expression<T> getExpression(String attrName, Join<?, ?> join, Root<R> root) {
        if (ObjectUtil.isNotEmpty(join)) {
            return join.get(attrName);
        }
        return root.get(attrName);
    }

    private static List<Field> getAllFields(Class<?> clazz, List<Field> fields) {
        if (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            JpaQueryUtils.getAllFields(clazz.getSuperclass(), fields);
        }
        return fields;
    }
}

