/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.data.mongo;

import cn.ziyicloud.framework.boot.autoconfigure.data.mongo.listener.SaveEventListener;
import com.mongodb.client.MongoClient;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
@ConditionalOnClass(value={MongoClient.class, MongoTemplate.class})
@AutoConfigureBefore(value={MongoAutoConfiguration.class})
public class ZiyiMongoAutoConfiguration {
    @Bean
    SaveEventListener saveEventListener(MongoTemplate mongoTemplate) {
        return new SaveEventListener(mongoTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public MappingMongoConverter mappingMongoConverter(MongoDatabaseFactory factory, MongoMappingContext context, MongoCustomConversions conversions) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MappingMongoConverter mappingConverter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
        mappingConverter.setCustomConversions((CustomConversions)conversions);
        mappingConverter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        mappingConverter.afterPropertiesSet();
        return mappingConverter;
    }
}

