/*
 * Decompiled with CFR 0.152.
 */
package cn.ziyicloud.framework.boot.autoconfigure.data.mongo.listener;

import cn.ziyicloud.framework.boot.autoconfigure.data.mongo.annotation.AutoIncrement;
import cn.ziyicloud.framework.boot.autoconfigure.data.mongo.entity.Sequence;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.util.ReflectionUtils;

public class SaveEventListener
extends AbstractMongoEventListener<Object> {
    public static final String ID_TYPE_STRING = "class java.lang.String";
    public static final String ID_TYPE_LONG = "class java.lang.Long";
    public static final String ID_TYPE_INTEGER = "class java.lang.Integer";
    private final MongoTemplate mongoTemplate;

    public SaveEventListener(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void onBeforeConvert(BeforeConvertEvent<Object> event) {
        Object source = event.getSource();
        ReflectionUtils.doWithFields(source.getClass(), field -> {
            Object value;
            Object idValue;
            ReflectionUtils.makeAccessible((Field)field);
            if (field.isAnnotationPresent(AutoIncrement.class) && (idValue = field.get(source)) == null) {
                String type = field.getGenericType().toString();
                Long nextId = this.getNextId(source.getClass().getSimpleName());
                switch (type) {
                    case "class java.lang.String": {
                        field.set(source, String.valueOf(nextId));
                        break;
                    }
                    case "class java.lang.Integer": {
                        field.set(source, nextId.intValue());
                        break;
                    }
                    case "class java.lang.Long": {
                        field.set(source, nextId);
                        break;
                    }
                }
            }
            if (field.isAnnotationPresent(CreatedDate.class) && (value = field.get(source)) == null) {
                field.set(source, LocalDateTime.now());
            }
            if (field.isAnnotationPresent(LastModifiedDate.class)) {
                field.set(source, LocalDateTime.now());
            }
        });
        super.onBeforeConvert(event);
    }

    private Long getNextId(String collName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"collName").is((Object)collName));
        Update update = new Update();
        update.inc("incId", (Number)1);
        FindAndModifyOptions options = new FindAndModifyOptions();
        options.upsert(true);
        options.returnNew(true);
        Sequence seq = (Sequence)this.mongoTemplate.findAndModify(query, (UpdateDefinition)update, options, Sequence.class);
        assert (seq != null);
        return seq.getIncId();
    }
}

